import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.transport.TransportFactory;
import java.util.Vector;

public class UDDIGetServiceDetail2 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		Vector skv = new Vector();
		skv.addElement("892a3470-3aaf-11d5-80dc-002035229c64");
		skv.addElement("892d41b0-3aaf-11d5-80dc-002035229c64");
		skv.addElement("bd22c024-5f93-43d0-b09e-eea188f19768");

		ServiceDetail sd = proxy.get_serviceDetail(skv);

		Vector bsv = sd.getBusinessServiceVector();
		if (bsv.size() == 0) {
			System.out.println("no service(s) found");
			System.exit(0);
		}

		System.out.println(bsv.size()+" service(s) found\n");
		for (int i = 0; i < bsv.size(); i++) {
			BusinessService bs = (BusinessService)bsv.elementAt(i);
			System.out.println(bs.getDefaultNameString());
			System.out.println(bs.getServiceKey());
			System.out.println("\n");
		}
	}
}